#Load necessary packages for analysis
install.packages("SiZer")
install.packages("dplyr")


library(SiZer)
library(dplyr)


#Import Data and Filter by Mgt Area
gkc<-read.csv("H:/UAF/Journal Article Prep/RSOS Article Submission/Data for Dryad Repository/SEAK_Male_SAM_Data.csv")

gkc

lyc<- gkc %>% filter(Area == "LyC")

lyc

lyc_smm<-piecewise.linear(lyc$CL,lyc$CH,
                     middle=1,CI=TRUE,bootstrap.samples=1000,sig.level=0.05)

lyc_smm

#Plot Results and add dotted line for CL where breakpoint occurs
plot(lyc_smm,xlab="",ylab="",xaxt='n',xlim=c(30,220),ylim=c(5,75))
axis(side=1, labels=F)
legend(25,75,bty="n",legend=c("A)"))
segments(147.3,0,147.3,33,col=2,lty=3,lwd=3)

#Repeat for remaining management areas

